for f in $(find -name '*.re'); do
    echo $f
    zfile="${f%.re}.zig"
    ztest="$(dirname $zfile)/example.zig"

    cat "$zfile" \
        | egrep -v 'warning: rule .*matches empty string \[-Wmatch-empty-string\]' \
        | egrep -v 'warning: tag .* degree of nondeterminism \[-Wnondeterministic-tags\]' \
        > "$ztest"

    # If the autogenerated message appears more than once in the file, then
    # it must have autogenerated header appended at the end. Cut it off.
    msg='// Code generated by re2zig, DO NOT EDIT.'
    if [ $(grep -c "$msg" "$ztest") -gt 1 ]; then
        # Get the line of the second message occurrence.
        l=$(grep -n "$msg" "$ztest" | tail -n +2 | cut -d : -f 1)
        # Cut off everything past that line.
        head -n $l "$ztest" > "$ztest".mod && mv "$ztest".mod "$ztest"
    fi

    zig test "$ztest" || { echo "*** error ***"; exit 1; }
    rm -f "$ztest"
done

echo "All good."
