"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModalContent = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const helpers_1 = require("../../../helpers");
const modal_box_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/ModalBox/modal-box"));
const bullseye_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/layouts/Bullseye/bullseye"));
const react_styles_1 = require("@patternfly/react-styles");
const helpers_2 = require("../../../helpers");
const Backdrop_1 = require("../../../components/Backdrop/Backdrop");
const ModalBoxBody_1 = require("./ModalBoxBody");
const ModalBoxCloseButton_1 = require("./ModalBoxCloseButton");
const ModalBox_1 = require("./ModalBox");
const ModalBoxFooter_1 = require("./ModalBoxFooter");
const ModalBoxDescription_1 = require("./ModalBoxDescription");
const ModalBoxHeader_1 = require("./ModalBoxHeader");
const ModalBoxTitle_1 = require("./ModalBoxTitle");
const ModalContent = (_a) => {
    var { children, className = '', isOpen = false, header = null, help = null, description = null, title = '', titleIconVariant = null, titleLabel = '', 'aria-label': ariaLabel = '', 'aria-describedby': ariaDescribedby, 'aria-labelledby': ariaLabelledby, bodyAriaLabel, bodyAriaRole, showClose = true, footer = null, actions = [], onClose = () => undefined, variant = 'default', position, positionOffset, width, maxWidth, boxId, labelId, backdropId, descriptorId, disableFocusTrap = false, hasNoBodyWrapper = false, ouiaId, ouiaSafe = true, elementToFocus } = _a, props = tslib_1.__rest(_a, ["children", "className", "isOpen", "header", "help", "description", "title", "titleIconVariant", "titleLabel", 'aria-label', 'aria-describedby', 'aria-labelledby', "bodyAriaLabel", "bodyAriaRole", "showClose", "footer", "actions", "onClose", "variant", "position", "positionOffset", "width", "maxWidth", "boxId", "labelId", "backdropId", "descriptorId", "disableFocusTrap", "hasNoBodyWrapper", "ouiaId", "ouiaSafe", "elementToFocus"]);
    if (!isOpen) {
        return null;
    }
    const modalBoxHeader = header ? ((0, jsx_runtime_1.jsx)(ModalBoxHeader_1.ModalBoxHeader, { help: help, children: header })) : (title && ((0, jsx_runtime_1.jsxs)(ModalBoxHeader_1.ModalBoxHeader, { help: help, children: [(0, jsx_runtime_1.jsx)(ModalBoxTitle_1.ModalBoxTitle, { title: title, titleIconVariant: titleIconVariant, titleLabel: titleLabel, id: labelId }), description && (0, jsx_runtime_1.jsx)(ModalBoxDescription_1.ModalBoxDescription, { id: descriptorId, children: description })] })));
    const modalBoxFooter = footer ? ((0, jsx_runtime_1.jsx)(ModalBoxFooter_1.ModalBoxFooter, { children: footer })) : (actions.length > 0 && (0, jsx_runtime_1.jsx)(ModalBoxFooter_1.ModalBoxFooter, { children: actions }));
    const defaultModalBodyAriaRole = bodyAriaLabel ? 'region' : undefined;
    const hasNoDescription = !description && !ariaDescribedby;
    const id = hasNoDescription ? descriptorId : undefined;
    const modalBody = hasNoBodyWrapper ? (children) : ((0, jsx_runtime_1.jsx)(ModalBoxBody_1.ModalBoxBody, Object.assign({ "aria-label": bodyAriaLabel, role: bodyAriaRole || defaultModalBodyAriaRole }, props, { id: id, children: children })));
    const ariaLabelledbyFormatted = () => {
        if (ariaLabelledby === null) {
            return null;
        }
        const idRefList = [];
        if ((ariaLabel && boxId) !== '') {
            idRefList.push(ariaLabel && boxId);
        }
        if (ariaLabelledby) {
            idRefList.push(ariaLabelledby);
        }
        if (title) {
            idRefList.push(labelId);
        }
        return idRefList.join(' ');
    };
    const modalBox = ((0, jsx_runtime_1.jsxs)(ModalBox_1.ModalBox, Object.assign({ id: boxId, className: (0, react_styles_1.css)(className, (0, ModalBoxTitle_1.isVariantIcon)(titleIconVariant) && modal_box_1.default.modifiers[titleIconVariant]), variant: variant, position: position, positionOffset: positionOffset, "aria-label": ariaLabel, "aria-labelledby": ariaLabelledbyFormatted(), "aria-describedby": ariaDescribedby || (hasNoBodyWrapper ? null : descriptorId) }, (0, helpers_2.getOUIAProps)(exports.ModalContent.displayName, ouiaId, ouiaSafe), { style: Object.assign(Object.assign({}, (width && { '--pf-v6-c-modal-box--Width': typeof width !== 'number' ? width : `${width}px` })), (maxWidth && {
            '--pf-v6-c-modal-box--MaxWidth': typeof maxWidth !== 'number' ? maxWidth : `${maxWidth}px`
        })), children: [showClose && (0, jsx_runtime_1.jsx)(ModalBoxCloseButton_1.ModalBoxCloseButton, { onClose: (event) => onClose(event), ouiaId: ouiaId }), modalBoxHeader, modalBody, modalBoxFooter] })));
    return ((0, jsx_runtime_1.jsx)(Backdrop_1.Backdrop, { id: backdropId, children: (0, jsx_runtime_1.jsx)(helpers_1.FocusTrap, { active: !disableFocusTrap, focusTrapOptions: {
                clickOutsideDeactivates: true,
                tabbableOptions: { displayCheck: 'none' },
                // FocusTrap's initialFocus can accept false as a value to prevent initial focus.
                // We want to prevent this in case false is ever passed in.
                initialFocus: elementToFocus || undefined
            }, className: (0, react_styles_1.css)(bullseye_1.default.bullseye), children: modalBox }) }));
};
exports.ModalContent = ModalContent;
exports.ModalContent.displayName = 'ModalContent';
//# sourceMappingURL=ModalContent.js.map