/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// Generated by jextract

package jdk.internal.ffi.generated.kqueue;

import java.lang.foreign.*;
import java.lang.invoke.*;

@SuppressWarnings("restricted")
public class kqueue_h extends kqueue_h$shared {

    kqueue_h() {
        // Should not be called directly
    }

    static final Arena LIBRARY_ARENA = Arena.ofAuto();

    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup()
            .or(Linker.nativeLinker().defaultLookup());

    private static final int EV_ADD = (int)1L;
    /**
     * {@snippet lang=c :
     * #define EV_ADD 1
     * }
     */
    public static int EV_ADD() {
        return EV_ADD;
    }
    private static final int EV_DELETE = (int)2L;
    /**
     * {@snippet lang=c :
     * #define EV_DELETE 2
     * }
     */
    public static int EV_DELETE() {
        return EV_DELETE;
    }
    private static final int EV_ONESHOT = (int)16L;
    /**
     * {@snippet lang=c :
     * #define EV_ONESHOT 16
     * }
     */
    public static int EV_ONESHOT() {
        return EV_ONESHOT;
    }
    private static final int EV_CLEAR = (int)32L;
    /**
     * {@snippet lang=c :
     * #define EV_CLEAR 32
     * }
     */
    public static int EV_CLEAR() {
        return EV_CLEAR;
    }

    private static class kqueue {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(
            kqueue_h.C_INT    );

        public static final MemorySegment ADDR = SYMBOL_LOOKUP.findOrThrow("kqueue");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * int kqueue()
     * }
     */
    public static FunctionDescriptor kqueue$descriptor() {
        return kqueue.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * int kqueue()
     * }
     */
    public static MethodHandle kqueue$handle() {
        return kqueue.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * int kqueue()
     * }
     */
    public static MemorySegment kqueue$address() {
        return kqueue.ADDR;
    }

    /**
     * {@snippet lang=c :
     * int kqueue()
     * }
     */
    public static int kqueue() {
        var mh$ = kqueue.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("kqueue");
            }
            return (int)mh$.invokeExact();
        } catch (Error | RuntimeException ex) {
           throw ex;
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class kevent {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(
            kqueue_h.C_INT,
            kqueue_h.C_INT,
            kqueue_h.C_POINTER,
            kqueue_h.C_INT,
            kqueue_h.C_POINTER,
            kqueue_h.C_INT,
            kqueue_h.C_POINTER
        );

        public static final MemorySegment ADDR = SYMBOL_LOOKUP.findOrThrow("kevent");

        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC);
    }

    /**
     * Function descriptor for:
     * {@snippet lang=c :
     * int kevent(int kq, const struct kevent *changelist, int nchanges, struct kevent *eventlist, int nevents, const struct timespec *timeout)
     * }
     */
    public static FunctionDescriptor kevent$descriptor() {
        return kevent.DESC;
    }

    /**
     * Downcall method handle for:
     * {@snippet lang=c :
     * int kevent(int kq, const struct kevent *changelist, int nchanges, struct kevent *eventlist, int nevents, const struct timespec *timeout)
     * }
     */
    public static MethodHandle kevent$handle() {
        return kevent.HANDLE;
    }

    /**
     * Address for:
     * {@snippet lang=c :
     * int kevent(int kq, const struct kevent *changelist, int nchanges, struct kevent *eventlist, int nevents, const struct timespec *timeout)
     * }
     */
    public static MemorySegment kevent$address() {
        return kevent.ADDR;
    }

    /**
     * {@snippet lang=c :
     * int kevent(int kq, const struct kevent *changelist, int nchanges, struct kevent *eventlist, int nevents, const struct timespec *timeout)
     * }
     */
    public static int kevent(int kq, MemorySegment changelist, int nchanges, MemorySegment eventlist, int nevents, MemorySegment timeout) {
        var mh$ = kevent.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                traceDowncall("kevent", kq, changelist, nchanges, eventlist, nevents, timeout);
            }
            return (int)mh$.invokeExact(kq, changelist, nchanges, eventlist, nevents, timeout);
        } catch (Error | RuntimeException ex) {
           throw ex;
        } catch (Throwable ex$) {
           throw new AssertionError("should not reach here", ex$);
        }
    }
    private static final int EVFILT_READ = (int)-1L;
    /**
     * {@snippet lang=c :
     * #define EVFILT_READ -1
     * }
     */
    public static int EVFILT_READ() {
        return EVFILT_READ;
    }
    private static final int EVFILT_WRITE = (int)-2L;
    /**
     * {@snippet lang=c :
     * #define EVFILT_WRITE -2
     * }
     */
    public static int EVFILT_WRITE() {
        return EVFILT_WRITE;
    }
}
